##### References: 
Offer Lifecycle Process - [[OLP_Handbook.PAL.docx]]
[[Dell Technologies OLP Overview.pptx]]

##### Offer definition
Any hardware, software, solution, services. Typically, they include
- Platform: desktop, laptop, storage, server
- Software: applications, operating systems, management software
- Solution: Integration of platform, cloud solutions
- Peripherals: memory, keyboards, displays
- Service: warranty and support, deployment, configuration services
- SaaS: Software as a Service provided in a cloud environment such as backup, cloud storage
##### Phases in OLP waterfall: 

| OLP Phase       | Phase Objectives                                        | Phase Exit Criteria                                                         |
| --------------- | ------------------------------------------------------- | --------------------------------------------------------------------------- |
| Ideate/Incubate | Evaluate offer idea and technical feasibility           | Idea overview                                                               |
| Concept         | Define preliminary offer requirements and business case | Approved program charter                                                    |
| Define          | Define detailed offer requirements                      | Approved PRD 1.0                                                            |
| Plan            | Create and commit to cross-functional POR               | Approved PRD 2.0                                                            |
| Develop         | Develop offer and execute cross-functional plans        | Approved PRD and phase exit                                                 |
| Launch          | Release and monitor offer in the marketplace            | Ready to Ship (RTS), Launch objectives (GTM prep, production readiness) met |
| Sustain         | Support offer to ensure ongoing commercial viability    | End of life criteria met                                                    |
Offers may be individual products (hardware/software/applications), services, or solutions consisting of combined or integrated products and/or services.

##### Core team structure
- Program Management
- Product Marketing 
- Product Management
- Development / Engineering
- Quality
- Worldwide Procurement (WWP) 
- Support and Deployment Services (SDS) New Product Introduction (NPI)
- Global Operations (Manufacturing)
- Experience Design Group (EDG)
##### Offer complexity tier
- Tier 1 - high impact, complexity - Major hardware/software solutions with significant technology and architecture changes, new business model, new market entry, high strategic value
- Tier 2 - Medium impact, complexity - Shorter release cycle, minor hardware changes, medium business risk
- Tier 3 - Lower impact, complexity - Minor technology transition or bug fixes, limited strategic value and risk, country expansion
##### Risk assessment
NUDD approach - 
New
Unique
Different
Difficult
##### Product Requirements Document - PRD
[[PRD.PAL.docx]] contains: 
1.	Executive Summary
2.	Offer Overview
	2.1	Offer Description	
	2.2	Value Proposition Summary	
	2.3	Key Feature/functionality & Dell Differentiation	
3.	Claims Support Requirements	
	3.1	Key Messages/Claims and Associated Enablement Requirements	
4.	Business Case & Forecasting Considerations	
	4.1	Market Timing	
	4.2	Cost Budget	
	4.3	Pricing Strategy	
	4.4	Estimated Revenue, Margin, Units	
	4.5	Recommended configurations or peripheral upsells (if applicable)	
	4.6	Country Ship-To list (CSTL 1.0) and launch timing	
	4.7	Transition Planning	
5.	Customer Validation Requirements	
	5.1	Beta/ Qual-Build/Eval Outline	
6.	Offer Requirements	
	6.1	Brand experience alignment (Client Solutions PC offers only - Partner with Brand Experience Manager)
	6.2	Dell-on-Dell Solution “Better together” requirements
	6.3	Design & Experience Language Definition
	6.4	Targeted Customer Experience / VoC Requirements	
	6.5	Platform Requirements
	6.6	Certification & Compliance Requirements
	6.7	Service-Offer Requirements
	6.8	Vendor/Partner Requirements
7.	Sales Requirements	
	7.1	Coverage & Capabilities Required	
	7.2	Readiness/Sales Enablement	
	7.3	Expected Sales Motions Use Cases	
8.	Business Operations Requirements	
	8.1	Sales tools readiness	
9.	Business Capability Gaps and Remediation plan	
	9.1	Develop	
	9.2	Marketing	
	9.3	Sales	
	9.4	Fulfill	
	9.5	Services	
	9.6	Other	
10.	Program Management Requirements	
	10.1	New, Unique, Different & Difficult (NUDD) Summary	
	10.2	Prioritized Key Dependencies or Program Boundaries required to support Program RTS	
	10.3	Prioritized Key UI (Under Investigation) Tracking Table	
	10.4	Core team	
	10.5	Key milestones, decision gates and timing	
	10.6	Approvals	
	10.7	Core Team Project Plan / Detailed schedule	
	10.8	Issues Log	
	10.9	Risks & Mitigation Plan	
11.	PRD 2.0/Program Plan 1.0 Approval	